
local location "<place directory for raw SIH and HES data here>"
local glocation "<place directory for your clean data>"

*******************************
*SETUP
********************************
***********
*2003/04
***********

use "`location'\hes03bl.dta" , clear 
merge m:1 ABSHID using "`location'\hes03bh.dta" , keepusing(HESHHWT DISPCH AGERHBC VSHARCH VFINCH VDEBCH VPLNCH HVALUECH VRPRCH STATEHBC) nogen keep(match master)

g lwt = . 
rename HESHHWT hwt 
rename DISPCH dinc
rename AGER age 
rename VSHARCH shares 
rename VFINCH deposits
rename VDEBCH bonds 
rename VPLNCH loans 
rename HVALUECH hprice 
rename VRPRCH hprice_other 
rename STATEHBC state
g offset = 0 

g loanpurpose = MPURL
g startyear = YRRPMTL 
g intrate = CURINTL
g term = TRMMLN 
g origloan = AMTBRLN
g mpayment = WKREPLN
g hdebt = AMTOLN
g loanno= LOANNUMB
destring loanno, replace 

keep ABSHID loanpurpose startyear intrate term origloan hdebt loanno mpayment dinc shares deposits offset bonds loans hprice hprice_other age state 
*I think these are consistent across all the years
g agegroup = 0 
*<25
replace agegroup = 1 if age < 11 
*25-34
replace agegroup = 2 if age >= 11 & age <= 12 
*35-44
replace agegroup = 3 if age >= 13 & age <= 14
*45-54
replace agegroup = 4 if age >= 15 & age <=16
*55-64
replace agegroup = 5 if age > 16 & age <= 26 
*65+
replace agegroup = 6 if age > 26 

g year = 2004
save "`glocation'\sihloan2004.dta", replace


********* 
*2007/08
*********
use "I:\HES\SIH2007_08\SIH08BL.DTA" , clear
merge m:1 ABSHID using "I:\HES\SIH2007_08\Sih08bh.dta" , keepusing(SIHHHWT DISPSCH DISPSCH8 AGERHBC STATEHBC) nogen keep(match master)

*NO WEALTH DATA 
rename DISPSCH dinc
rename AGERHBC age 
*rename vsharch shares 
*rename vfinch deposits
*rename voftch offset
*rename vdebch  bonds 
*rename vplnch loans 
rename STATEHBC state 

rename SIHLNWT lwt
rename SIHHHWT hwt 

*g mortgage = (MPURL<5)
*keep if mortgage == 1 
rename MPURL loanpurpose 

g startyear = YRRPMTL  

*Annual 
g intrate = CURINTL  

g term = 30 

*Original size of loan 
g origloan = AMTBRLN  

g hdebt = AMTOLN  
g loanno= ABSLID  
destring loanno, replace 

g mpayment = WKREPLN 
*replace mpayment = mpayment*52 

keep ABSHID hwt lwt startyear loanpurpose intrate term origloan hdebt loanno mpayment dinc age state 

*I think these are consistent across all the years
g agegroup = 0 
*<25
replace agegroup = 1 if age < 11 
*25-34
replace agegroup = 2 if age >= 11 & age <= 12 
*35-44
replace agegroup = 3 if age >= 13 & age <= 14
*45-54
replace agegroup = 4 if age >= 15 & age <=16
*55-64
replace agegroup = 5 if age > 16 & age <= 26 
*65+
replace agegroup = 6 if age > 26 

*The shares look very different to other years...

g year = 2008
save "`glocation'\sihloan2008.dta", replace


********* 
*2009/10
*********
use "I:\HES\SIH2009_10\sih10bl.dta" , clear
merge m:1 ABSHID using "I:\HES\SIH2009_10\Sih10bh.dta" , keepusing(SIHHHWT DISPSCH DISPSCH8 VSHARCH VFINCH VDEBCH VPLNCH HVALPRIC HVALUECH VRPRCH AGERHBC STATEHBC) nogen keep(match master)

rename MPURL loanpurpose
rename CURINTL intrate
rename SIHLNWT lwt
rename YRRPMTL startyear
rename AMTBRLN origloan
rename AMTOLN  hdebt
rename WKREPLN mpayment 
rename ABSLID  loanno 
destring loanno, replace 
g term = 30 

rename SIHHHWT hwt 
rename DISPSCH dinc
rename AGERHBC age
rename VSHARCH  shares 
rename VFINCH deposits
*rename voftch offset
rename VDEBCH bonds 
rename VPLNCH loans 
rename HVALPRIC purchprice 
rename HVALUECH hprice 
rename VRPRCH hprice_other 
rename STATEHBC state 
g offset = 0 

keep ABSHID hwt lwt startyear loanpurpose intrate term origloan hdebt loanno mpayment dinc shares deposits bonds loans offset purchprice hprice hprice_other age state

*I think these are consistent across all the years
g agegroup = 0 
*<25
replace agegroup = 1 if age < 11 
*25-34
replace agegroup = 2 if age >= 11 & age <= 12 
*35-44
replace agegroup = 3 if age >= 13 & age <= 14
*45-54
replace agegroup = 4 if age >= 15 & age <=16
*55-64
replace agegroup = 5 if age > 16 & age <= 26 
*65+
replace agegroup = 6 if age > 26 


g year = 2010
save "`glocation'\sihloan2010.dta", replace


*2011/12
use "I:\HES\SIH2011_12\sih11bl.dta" , clear
merge m:1 ABSHID using "I:\HES\SIH2011_12\Sih11bh.dta" , keepusing(SIHHHWT DISPSCH DISPSCH8 VSHARCH VFINCH VDEBCH VPLNCH VOFTCH HVALPRIC HVALUECH VRPRCH AGERHBC STATEHBC) nogen keep(match master)

rename MPURL loanpurpose
rename CURINTL intrate
rename SIHLNWT lwt
rename YRRPMTL startyear
rename AMTBRLN origloan
rename AMTOLN  hdebt
rename WKREPLN mpayment 
rename ABSLID  loanno 
destring loanno, replace 
g term = 30 

rename SIHHHWT hwt 
rename DISPSCH dinc
rename AGERHBC age
rename VSHARCH  shares 
rename VFINCH deposits
rename VOFTCH offset
rename VDEBCH bonds 
rename VPLNCH loans 
rename HVALPRIC purchprice
rename HVALUECH hprice
rename VRPRCH hprice_other 
rename STATEHBC state 

keep ABSHID hwt lwt startyear loanpurpose intrate term origloan hdebt loanno mpayment dinc shares deposits bonds loans offset purchprice hprice hprice_other age state

*I think these are consistent across all the years
g agegroup = 0 
*<25
replace agegroup = 1 if age < 11 
*25-34
replace agegroup = 2 if age >= 11 & age <= 12 
*35-44
replace agegroup = 3 if age >= 13 & age <= 14
*45-54
replace agegroup = 4 if age >= 15 & age <=16
*55-64
replace agegroup = 5 if age > 16 & age <= 26 
*65+
replace agegroup = 6 if age > 26 


g year = 2012
save "`glocation'\sihloan2012.dta", replace

*2013/14
use "I:\HES\SIH2013_14\sih13bl.dta" ,clear
merge m:1 ABSHID using "I:\HES\SIH2013_14\Sih13bh.dta" , keepusing(SIHHHWT DISPSCH DISPSCH8 VSHARCH VFINCH VDEBCH VPLNCH VOFTCH HVALPRIC HVALUECH VRPRCH AGERHBC STATEHBC) nogen keep(match master)

rename MPURL loanpurpose
rename CURINTL intrate
rename SIHLNWT lwt
rename YRRPMTL startyear
rename AMTBRLN origloan
rename AMTOLN  hdebt
rename WKREPLN mpayment 
rename ABSLID  loanno 
destring loanno, replace 
g term = 30 

rename SIHHHWT hwt 
rename DISPSCH dinc
rename AGERHBC age
rename VSHARCH  shares 
rename VFINCH deposits
rename VOFTCH offset
rename VDEBCH bonds 
rename VPLNCH loans 
rename HVALPRIC purchprice
rename HVALUECH hprice
rename VRPRCH hprice_other 
rename STATEHBC state 

keep ABSHID hwt lwt startyear loanpurpose intrate term origloan hdebt loanno mpayment dinc shares deposits bonds loans offset purchprice hprice hprice_other age state

*I think these are consistent across all the years
g agegroup = 0 
*<25
replace agegroup = 1 if age < 11 
*25-34
replace agegroup = 2 if age >= 11 & age <= 12 
*35-44
replace agegroup = 3 if age >= 13 & age <= 14
*45-54
replace agegroup = 4 if age >= 15 & age <=16
*55-64
replace agegroup = 5 if age > 16 & age <= 26 
*65+
replace agegroup = 6 if age > 26 



g year = 2014
save "`glocation'\sihloan2014.dta", replace

*2015/16
use "I:\HES\SIH2015_16\SIH15BL.dta" , clear
merge m:1 abshid using "I:\HES\SIH2015_16\Sih15bh.dta" , keepusing(sihhhwt dispsch dispsch8 vsharch vfinch vdebch vplnch voftch hvaluech vrprch hvalpric agerhec statehec) nogen keep(match master)



rename mpurl  loanpurpose
rename curintl intrate
rename sihlnwt lwt
rename yrrpm startyear
rename amtbrln origloan
rename amtoln hdebt
rename wkrepln mpayment 
rename abslid loanno 
destring loanno, replace 
g term = 30 

rename sihhhwt  hwt 
rename dispsch dinc
rename agerhec age
rename vsharch shares 
rename vfinch deposits
rename voftch offset
rename vdebch bonds 
rename vplnch loans 
rename hvaluech hprice 
rename vrprch hprice_other
rename hvalpric purchprice
rename statehec state 

rename abshid ABSHID

keep ABSHID hwt lwt startyear loanpurpose intrate term origloan hdebt loanno mpayment dinc shares deposits bonds loans offset hprice hprice_other purchprice age state


g agegroup = 0 
*<25
replace agegroup = 1 if age < 25
*25-34
replace agegroup = 2 if age >24 & age < 35 
*35-44
replace agegroup = 3 if age > 34 & age < 45
*45-54
replace agegroup = 4 if age > 44 & age < 55
*55-64
replace agegroup = 5 if age > 54 & age < 65
*65+
replace agegroup = 6 if age > 64 


g year = 2016
save "`glocation'\sihloan2016.dta", replace



*2017/18
use "I:\HES\SIH2017_18\SIH17BL.dta", clear
merge m:1 abshid using "I:\HES\SIH2017_18\Sih17bh.dta" , keepusing(sihhhwt dispsch dispsch8 vsharch vfinch vdebch vplnch voftch hvaluech vrprch hvalpric agerhec statehec) nogen keep(match master)

rename mpurl  loanpurpose
rename curintl intrate
rename sihlnwt lwt
rename yrrpm startyear
rename amtbrln origloan
rename amtoln hdebt
rename wkrepln mpayment 
rename abslid loanno 
destring loanno, replace 
g term = 30 
rename amrepay abovemin
rename wkminre minpay 

rename sihhhwt  hwt 
rename dispsch dinc
rename agerhec age
rename vsharch shares 
rename vfinch deposits
rename voftch offset
rename vdebch bonds 
rename vplnch loans 

rename hvaluech hprice 
rename vrprch hprice_other
rename hvalpric purchprice
rename statehec state 

rename abshid ABSHID 
keep ABSHID hwt lwt startyear loanpurpose intrate term origloan hdebt loanno mpayment dinc shares deposits bonds loans offset minpay abovemin hprice hprice_other purchprice age state 


g agegroup = 0 
*<25
replace agegroup = 1 if age < 25
*25-34
replace agegroup = 2 if age >24 & age < 35 
*35-44
replace agegroup = 3 if age > 34 & age < 45
*45-54
replace agegroup = 4 if age > 44 & age < 55
*55-64
replace agegroup = 5 if age > 54 & age < 65
*65+
replace agegroup = 6 if age > 64 

g year = 2018
save "`glocation'\sihloan2018.dta", replace


clear
foreach i in 2004 2008 2010 2012 2014 2016 2018 {
append using "`glocation'\sihloan`i'.dta"
}
save "`glocation'\sihloan2004_2018.dta", replace

